/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_07;
import java.util.*; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class EncryptItems extends NotesThread{
	

	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	/**
	 * Anwendung zur Demonstration des Verhaltens bei der Feldverschlsselung
	 * @param argv
	 */
	public static void main(String[] args) {
		EncryptItems ei = new EncryptItems();
		ei.start();
	}
	public void runNotes() {
		Session session = null;
		Database db = null;
		Document doc = null, otherDoc = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase((String) null, "djbuch/djbuch.nsf");
			doc = beispiel1 (db);
			if (doc != null) {doc.recycle();}
			doc = beispiel2 (db);
			System.out.println (db.isOpen());
			doMailSend (db);
		} catch (NotesException e) {
			e.printStackTrace(System.err);
		} finally {
			try {
				if (doc != null) {doc.recycle();}
				if (otherDoc != null) {otherDoc.recycle();}
				if (db != null) {db.recycle();}
				if (session != null) {session.recycle();} 
			} catch (NotesException e) {
				System.err.println("Fataler Fehler.");
			}
		}
	}
	
	/**
	 * Encryption Demo.
	 * Erzeugt ein Dokument mit einem verschlsseltem Item und ldt es erneut.
	 * @param db - Database
	 * @return - Document
	 * @throws NotesException
	 */
	private static Document beispiel1 (Database db) throws NotesException {
		System.out.println (LINE + "\nBeispiel 1" + LINE);
		Document docOne=db.createDocument();
		docOne.replaceItemValue("Form", "FO_Dokument_k6");
		docOne.replaceItemValue("F_Titel", "Automatisch (1) erstellt am " 
				+ Calendar.getInstance().getTime());
		Item item = docOne.replaceItemValue("F_secret", "my Secret Value (1)");
		item.setEncrypted(true);
		Vector keys = new Vector ();
		keys.add("encryptionKey");
		docOne.setEncryptionKeys(keys);
		docOne.encrypt();
		boolean ok = docOne.save (true,false);
		String unid = docOne.getUniversalID();
		if (docOne != null) {docOne.recycle();docOne=null;}
		Document result = db.getDocumentByUNID(unid);
		System.out.println ("Dokument ist verschlsselt: " + result.isEncrypted());
		System.out.println ("Geheimer Wert: " + result.getItemValueString("F_secret"));
		System.out.println (result.getUniversalID());
		return result;
	}


	/**
	 * @param db - Database
	 * @return - Document
	 * @throws NotesException
	 */
	private static Document beispiel2(Database db) throws NotesException {
		System.out.println (LINE + "\nBeispiel 2" + LINE);
		Document result=db.createDocument();
		result.replaceItemValue("Form", "FO_Dokument_k6");
		result.replaceItemValue("F_Titel", "Automatisch (2) erstellt am " 
				+ Calendar.getInstance().getTime());
		Item item = result.replaceItemValue("F_secret", "my Secret Value");
		item.setEncrypted(true);
		Vector keys = new Vector ();
		keys.add("encryptionKey");
		result.setEncryptionKeys(keys);
		System.out.println ("Dokument ist verschlsselt: " + result.isEncrypted());
		result.encrypt();
		boolean ok = result.save (true,false);
		System.out.println ("Dokument gespeichert: " + ok);
		System.out.println ("Dokument ist verschlsselt: " + result.isEncrypted());
		System.out.println ("Geheimer Wert 1: " + result.getItemValueString("F_secret"));
		result.replaceItemValue ("F_sonst", "val");
		System.out.println ("Geheimer Wert 2: " + result.getItemValueString("F_secret"));
		result.save(true,false);
		System.out.println ("Dokument ist verschlsselt: " + result.isEncrypted());
		return result;
	}
	
	private static void doMailSend (Database db) throws NotesException {
		Document docOne = null;
		try {
			System.out.println (LINE + "\nBeispiel 3 - Mail send" + LINE);
			docOne=db.createDocument();
			String subject = "Automatisch (1) erstellt am " 
				+ Calendar.getInstance().getTime();
			docOne.replaceItemValue("Form", "Memo");
			docOne.replaceItemValue ("Subject", subject);
			docOne.replaceItemValue ("Principal", "tomtom");
			Item i = docOne.replaceItemValue ("Body","hallo hallo");
			docOne.replaceItemValue ("SendTo", "Administrator/DJBUCH");
			i.setEncrypted(true);
			i.setSigned(true);
			docOne.setEncryptOnSend(true);
			docOne.setSignOnSend(true);
			docOne.send();
			System.out.println ("Send done.");
		} finally {
			if (docOne != null) {docOne.recycle(); docOne=null;}
		}
	}

	private static final String LINE = "\n************************************************************";
}
